package org.example

import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.GlobalScope
import kotlinx.coroutines.async
import kotlinx.coroutines.cancel
import kotlinx.coroutines.currentCoroutineContext
import kotlinx.coroutines.delay
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.flowOf
import kotlinx.coroutines.flow.isActive
import kotlinx.coroutines.flow.launchIn
import kotlinx.coroutines.flow.onEach
import kotlinx.coroutines.flow.take
import kotlinx.coroutines.isActive
import kotlinx.coroutines.launch
import kotlinx.coroutines.sync.Mutex
import kotlinx.coroutines.withContext
import kotlin.time.Duration.Companion.seconds

suspend fun main() {
    val solution = Solution()
    println(solution.part1)
    println(solution.part2)

    val java = Asdf(solution)
    println(java.f(setOf(1, 2, 3)))
    println(java.part1)

    val scope = CoroutineScope(Dispatchers.Default)
    scope.launch {
        solution.sus()
//        val data = withContext(Dispatchers.IO) {
//            //reading from disc
//        }
//        withContext(Dispatchers.Main) {
//            // change text field
//        }
        println("I'm in thread")
    }

    val async = scope.async {
        println("Waiting...")
        delay(1.seconds)
        10
    }
    println(async.await())
    println(async.await())
    println("Done")

    val flow = flow {
        var i = 0
        while (currentCoroutineContext().isActive) {
            println("Emitting")
            emit(i++)
        }
    }

    flow.take(5).onEach { println(it) }.launchIn(scope).join()

    //scope.cancel()
}
