package org.example

import kotlinx.coroutines.delay
import kotlin.math.abs
import kotlin.time.Duration.Companion.hours
import kotlin.time.Duration.Companion.seconds

class Solution(resName: String = "input") {
    val input = object {}.javaClass.getResource("/$resName.txt")!!.readText()
        .lineSequence()
        .filter { it.isNotEmpty() }
        .map {
            val line = it.split("   ").map { it.toInt() }
            line.first() to line.last()
        }.unzip()

    @JvmOverloads
    fun aaa(lambda: () -> Unit, x: Int = 0, y: Int = 1, z: Int = 2) = x + y + z

    @JvmField
    val left = input.first
    val right = input.second

    val part1 by lazy {
        left.sorted().zip(right.sorted()) { l, r -> abs(l - r) }.sum()
    }

    val part2 by lazy {
        left.sumOf { l -> l * right.count { r -> r == l } }
    }

    suspend fun sus() {
        delay(5.seconds)
        println("Hotovo")
    }
}
