package org.example

import kotlinx.coroutines.GlobalScope
import kotlinx.coroutines.async
import kotlinx.coroutines.awaitAll
import kotlin.math.min

class Solution13(resName: String = "input13") {
    data class Machine(
        val a: Pair<Int, Int>,
        val b: Pair<Int, Int>,
        val prize: Pair<Int, Int>,
        val price: Int = 0,
        val pos: Pair<Int, Int> = 0 to 0,
    ) {
        fun minPrice(): Int {
            var minPrice = Int.MAX_VALUE
            val states = mutableListOf(this)
            while (states.isNotEmpty()) {
                val s = states.removeFirst()
                if (s.pos.first < s.prize.first && s.pos.second < s.prize.second) {
                    states += copy(pos = pos + s.a, price = price + 3)
                    states += copy(pos = pos + s.b, price = price + 1)
                    println(states)
                } else if (s.pos == s.prize) {
                    minPrice = min(minPrice, s.price)
                }
            }
            return minPrice
        }

        companion object {
            operator fun Pair<Int, Int>.plus(other: Pair<Int, Int>) = (first + other.first) to (second + other.second)
        }
    }

    val input = object {}.javaClass.getResource("/$resName.txt")!!.readText()
        .lineSequence()
        .filter { it.isNotEmpty() }
        .chunked(3)
        .map {
            Machine(
                NUMBERS_REGEX.find(it[0])!!.let { it.groupValues[1].toInt() to it.groupValues[2].toInt() },
                NUMBERS_REGEX.find(it[1])!!.let { it.groupValues[1].toInt() to it.groupValues[2].toInt() },
                NUMBERS_REGEX.find(it[2])!!.let { it.groupValues[1].toInt() to it.groupValues[2].toInt() },
            )
        }

    suspend fun part1() = input.map {
        GlobalScope.async { it.minPrice() }
    }.toList()
        .awaitAll()
        .filter { it != Int.MAX_VALUE }
        .sum()

    companion object {
        val NUMBERS_REGEX = """(\d+)\D+(\d+)""".toRegex()
    }
}
