package org.example

import io.kotest.core.spec.style.StringSpec
import io.kotest.matchers.shouldBe
import io.mockk.every
import io.mockk.mockk
import kotlinx.serialization.encodeToString
import kotlinx.serialization.json.Json

class GopasTest : StringSpec({
    "Part 1" {
        Solution().part1 shouldBe 11
    }

    "Part 2" {
        Solution().part2 shouldBe 31
    }

    "Mock" {
        val mockedSolution = mockk<Solution> {
            every { part1 } returns 100
        }
        mockedSolution.part1 shouldBe 100
    }

    "JSON" {
        val user = User(12, "Pepa")
        val json = """{"id":12,"name":"Pepa"}"""
        Json.decodeFromString<User>(json) shouldBe user
        Json.encodeToString(user) shouldBe json
    }
})
