package org.example

import io.kotest.core.spec.style.StringSpec
import io.kotest.matchers.nulls.shouldBeNull
import io.kotest.matchers.nulls.shouldNotBeNull
import io.kotest.matchers.sequences.shouldHaveSize
import io.kotest.matchers.shouldBe
import org.example.Solution13.Machine
import org.example.Solution13.Machine.Companion.plus

class GopasTest13 : StringSpec({
    "Regex" {
        Solution13.NUMBERS_REGEX.find("Bla bla 123 bla bla 456 bla bla").shouldNotBeNull().also {
            it.groupValues shouldBe listOf(
                "123 bla bla 456",
                "123",
                "456"
            )
        }
        Solution13.NUMBERS_REGEX.find("123").shouldBeNull()
        Solution13.NUMBERS_REGEX.find("Bla bla 123 bla bla").shouldBeNull()
        Solution13.NUMBERS_REGEX.find("kjgkljhljkhljk").shouldBeNull()
    }

    "Input" {
        Solution13().input.run {
            shouldHaveSize(4)
            last() shouldBe Machine(69 to 23, 27 to 71, 18641 to 10279)
        }
    }

    "Adding pairs" {
        (1 to 2) + (3 to 4) shouldBe (4 to 6)
    }

    "Min price" {
        Machine(2 to 2, 1 to 1, 2 to 2).minPrice() shouldBe 3
        Machine(2 to 2, 1 to 1, 1 to 1).minPrice() shouldBe 1
        Machine(2 to 2, 1 to 1, 1 to 2).minPrice() shouldBe Int.MAX_VALUE
//        Solution13().input.first().minPrice() shouldBe 280
    }

    "Part 1" {
        Solution().part1 shouldBe 11
    }

    "Part 2" {
        Solution().part2 shouldBe 31
    }
})
