package com.twentyfouri.tvlauncher.viewmodels

import android.view.View
import androidx.lifecycle.MutableLiveData
import com.twentyfouri.smartmodel.model.media.SmartAgeRating

class EntelRestrictionIconsViewModel : MediaRestrictionIconsViewModel() {

    val contentIconF = MutableLiveData<Int>()
    val contentIconI12 = MutableLiveData<Int>()
    val contentIconR = MutableLiveData<Int>()
    val contentIconA = MutableLiveData<Int>()

    init {
        setAllIcons(View.GONE)
    }

    private fun setAllIcons(visibility: Int) {
        contentIconF.value = visibility
        contentIconI12.value = visibility
        contentIconR.value = visibility
        contentIconA.value = visibility
    }

    override fun setContentIcons(ageRating: List<SmartAgeRating>?) {
        setAllIcons(View.GONE)
        if (ageRating == null) return
        for (rating in ageRating) {
            when (rating.rating.toUpperCase()) {
                "0" -> contentIconF.value = View.VISIBLE
                "6" -> contentIconF.value = View.VISIBLE
                "12" -> contentIconI12.value = View.VISIBLE
                "16" -> contentIconR.value = View.VISIBLE
                "18" -> contentIconA.value = View.VISIBLE
                "A" -> contentIconA.value = View.VISIBLE
                "F" -> contentIconF.value = View.VISIBLE
                "G" -> contentIconF.value = View.VISIBLE
                "I12" -> contentIconI12.value = View.VISIBLE
                "NC-17" -> contentIconA.value = View.VISIBLE
                "NR" -> contentIconA.value = View.VISIBLE
                "PG-13" -> contentIconR.value = View.VISIBLE
                "PG" -> contentIconI12.value = View.VISIBLE
                "R" -> contentIconR.value = View.VISIBLE
                "TV-14" -> contentIconR.value = View.VISIBLE
                "TV-G" -> contentIconF.value = View.VISIBLE
                "TV-MA" -> contentIconA.value = View.VISIBLE
                "TV-PG" -> contentIconI12.value = View.VISIBLE
                "TV-Y" -> contentIconF.value = View.VISIBLE
                "TV-Y7" -> contentIconI12.value = View.VISIBLE
                else -> contentIconA.value = View.VISIBLE
            }
        }
    }


}