// RemoteLoggingInterface.aidl
package com.twentyfouri.tvlauncher.services;

interface RemoteLoggingInterface {
    /**
     * Enable remote logging.
     *
     * Passing a value for time above zero limits the duration of the remote logging
     * session (in seconds).
     *
     * Setting a value for storage above zero overrides the minimum available storage space (in MB).
     * The default value is 300. If remaining storage space is less than this value then logging will be stopped (or not started).
     */
    oneway void enableRemoteLogging(int time, int storage);

    /**
     * Disable remote logging, if it was already enabled.
     */
    oneway void disableRemoteLogging();

    /**
     * Always returns one of the following:
     * ENABLED
     * DISABLED
     * ENABLING_IN_PROGRESS
     * ENABLING_FAILED
     *
     * This would have been an enum, but enums in AIDL are only available
     * on Android 11 (SDK 30) and up.
     */
    String getRemoteLoggingStatus();

    /**
     * Returns the remote logging status in a more detailed human-readable format.
     */
    String getDetailedRemoteLoggingStatus();
}
