package com.twentyfouri.tvlauncher.adapters

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.DiffUtil
import androidx.recyclerview.widget.ListAdapter
import androidx.recyclerview.widget.RecyclerView
import com.twentyfouri.tvlauncher.R
import com.twentyfouri.tvlauncher.data.ListPickerItem
import com.twentyfouri.tvlauncher.widgets.SettingsItemType
import com.twentyfouri.tvlauncher.widgets.SettingsItemView

class ListPickerAdapter(var listener: OnItemPickedListener? = null) :
    ListAdapter<ListPickerItem, ListPickerAdapter.ListPickerViewHolder>(ListPickerItemDiffCallback()) {

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ListPickerViewHolder {
        val settingsItemView = LayoutInflater.from(parent.context).inflate(
            R.layout.settings_item_for_viewholder,
            parent,
            false) as SettingsItemView
        return ListPickerViewHolder(settingsItemView)
    }

    override fun onBindViewHolder(holder: ListPickerViewHolder, position: Int) {
        holder.settingsItemView.binding.viewModel?.setFromListPickerItem(position, getItem(position))
        if(getItem(position).type == SettingsItemType.SECTION_LABEL) {
            holder.settingsItemView.focusable = View.NOT_FOCUSABLE
        } else {
            holder.settingsItemView.setOnClickListener { listener?.onItemPicked(position, getItem(position)) }
        }
    }

    class ListPickerViewHolder(
        val settingsItemView: SettingsItemView
    ) : RecyclerView.ViewHolder(settingsItemView)

    class ListPickerItemDiffCallback : DiffUtil.ItemCallback<ListPickerItem>() {

        override fun areItemsTheSame(
            oldItem: ListPickerItem,
            newItem: ListPickerItem
        ): Boolean {
            return oldItem == newItem
        }

        override fun areContentsTheSame(
            oldItem: ListPickerItem,
            newItem: ListPickerItem
        ): Boolean {
            return oldItem == newItem
        }
    }

    fun interface OnItemPickedListener {
        fun onItemPicked(position: Int, item: ListPickerItem)
    }
}