package com.twentyfouri.tvlauncher.adapters

import com.twentyfouri.tvlauncher.R
import com.twentyfouri.tvlauncher.common.utils.NetworkConnectionState
import com.twentyfouri.tvlauncher.ui.MainActivity
import com.twentyfouri.tvlauncher.viewmodels.RowViewModel
import com.twentyfouri.tvlauncher.widgets.OfflineRow

class OfflineViewHolder(
    override val rowView: OfflineRow
) : RowAdapterViewHolder(rowView) {

    override fun bind(rowViewModel: RowViewModel, position: Int) {
        rowViewModel.forceHide.value =
            if ((rowView.context as? MainActivity)?.isInOnlineMode() == true) {
                true
            } else {
                NetworkConnectionState.instance.state == NetworkConnectionState.State.OFFLINE
            }
        rowView.bind(rowViewModel)
    }

    override fun onAttached() {
        val mainActivity = rowView.context as? MainActivity ?: return
        mainActivity.navigateLoader(
            visible = false,
            handleSplash = true,
            delay = rowView.context.resources.getInteger(R.integer.splash_screen_loading_offset).toLong()
        )
    }
}