package com.twentyfouri.tvlauncher.adapters

import android.util.Log
import androidx.lifecycle.LifecycleOwner
import androidx.lifecycle.Observer
import com.twentyfouri.tvlauncher.R
import com.twentyfouri.tvlauncher.ui.MainActivity
import com.twentyfouri.tvlauncher.viewmodels.RowViewModel
import com.twentyfouri.tvlauncher.widgets.RowView

class RowViewViewHolder(
    override val rowView: RowView
) : RowAdapterViewHolder(rowView) {

    override fun bind(rowViewModel: RowViewModel, position: Int) {
        rowView.bind(rowViewModel)
    }

    override fun onAttached() {
        //hides loader
        val mainActivity = rowView.context as? MainActivity ?: return
        mainActivity.navigateLoader(
                visible = false,
                handleSplash = true,
                delay = rowView.context.resources.getInteger(R.integer.splash_screen_loading_offset).toLong()
        )
        rowView.onAttached()
    }

    override fun onDetached() {
        rowView.onDetached()
    }
}