package com.twentyfouri.tvlauncher.adapters

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.BaseAdapter
import androidx.databinding.DataBindingUtil
import androidx.databinding.ViewDataBinding
import com.twentyfouri.androidcore.utils.setImageSpecification
import com.twentyfouri.smartmodel.model.dashboard.SmartImages
import com.twentyfouri.smartmodel.model.dashboard.SmartMediaItem
import com.twentyfouri.tvlauncher.Flavor
import com.twentyfouri.tvlauncher.ImageType
import com.twentyfouri.tvlauncher.R
import com.twentyfouri.tvlauncher.databinding.SubscriptionChannelItemBinding
import com.twentyfouri.tvlauncher.utils.ExpirableGlideImageSpecification

class SubscriptionChannelsAdapter(private val channels: List<SmartMediaItem>) : BaseAdapter() {

    override fun getCount(): Int {
        return channels.size
    }

    override fun getItemId(position: Int): Long {
        return 0
    }

    override fun getItem(position: Int): Any? {
        return null
    }

    override fun getView(position: Int, convertView: View?, parent: ViewGroup?): View {
        val gridItemView: View
        val binding: ViewDataBinding
        if (convertView == null) {
            binding = DataBindingUtil.inflate<SubscriptionChannelItemBinding>(
                    LayoutInflater.from(parent?.context),
                    R.layout.subscription_channel_item,
                    parent,
                    false)
            gridItemView = binding.root
            val text = binding.subscriptionChannelText
            val image = binding.subscriptionChannelIcon
            text.text = channels.get(position).title
            image.setImageSpecification(
                    (Flavor().pickBasedOnFlavor(Flavor().getImageOfType(
                            channels[position],
                            ImageType.DARK
                    ),
                            (R.dimen.not_subscribed_grid_channel_icon_width),
                            (R.dimen.not_subscribed__grid_channel_icon_height),
                            SmartImages.UNRESTRICTED
                    )?.let { ExpirableGlideImageSpecification(it) })
            )
        } else {
            gridItemView = convertView
        }
        return gridItemView
    }
}