package com.twentyfouri.tvlauncher.data

import android.content.Intent
import android.content.res.Resources
import android.graphics.drawable.Drawable
import androidx.annotation.ColorInt
import androidx.core.content.res.ResourcesCompat

open class AppListItem(
    var intent: Intent,
    var banner: Drawable? = null,
    var icon: Drawable? = null,
    var label: CharSequence? = null,
    var timeOfUse: Long = 0,
    val isFavouriteItem: Boolean = false,
    backgroundColor: Int = 0) : Comparable<AppListItem> {

    val backgroundColor: Int
        @ColorInt
        get() = ResourcesCompat.getColor(Resources.getSystem(), android.R.color.holo_blue_light, null)

    fun getLabelAsSafeString() = if (label == null) "" else label!!.toString()

    /**
     * Returns whether this item should appear identical to the given item.
     * @param another Item to compare to
     * @return True if items should appear identical
     */
    fun areContentsTheSame(another: AppListItem): Boolean {
        return (another.banner == banner
                && another.icon == icon
                && another.label == label)
    }

    override fun compareTo(other: AppListItem): Int {
        val priorityDiff = other.timeOfUse - timeOfUse
        return if (priorityDiff != 0L) {
            if (priorityDiff < 0L) -1 else 1
        } else {
            getLabelAsSafeString().compareTo(other.getLabelAsSafeString())
        }
    }

    override fun equals(other: Any?): Boolean {
        return other is AppListItem && intent == other.intent
    }

    override fun hashCode(): Int {
        return intent.hashCode()
    }

    override fun toString(): String {
        val componentName = if (intent.component == null) "" else intent.component.toString()
        return getLabelAsSafeString() + " -- " + componentName
    }

    fun toDebugString(): String {
        return ("Label: " + label
                + " Intent: " + intent
                + " Banner: " + banner
                + " Icon: " + icon
                + " Priority: " + java.lang.Long.toString(timeOfUse))
    }
}
