package com.twentyfouri.tvlauncher.data

import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch
import org.joda.time.DateTime

class AppUsageRepository(
    private val appUsageDao: AppUsageDao
) {

    fun saveTimeOfPackage(packageName: String?){
        CoroutineScope(Dispatchers.IO).launch {
            if (packageName != null) {
                try {
                    if (appUsageDao.getTimeOfUseByPackageName(packageName) == 0L)
                        appUsageDao.insert(AppUsage(packageName, DateTime.now().millis))
                    else
                        appUsageDao.updateTimeOfUseByPackageName(DateTime.now().millis, packageName)
                } catch (e: Exception) {
                    e.printStackTrace()
                }
            }
        }
    }

}