package com.twentyfouri.tvlauncher.data

import com.twentyfouri.smartmodel.model.dashboard.SmartMediaItem
import java.io.Serializable

enum class ColumnItemType {
    LABEL,
    RECORDING,
    RECORDING_EPISODES
}

class ColumnItem (
    var type: ColumnItemType,
    val text: String? = null,
    val recording: SmartMediaItem? = null,
    var recordingEpisodes: List<SmartMediaItem>? = null
) : Serializable {
    override fun equals(other: Any?): Boolean {
        return when {
            other !is ColumnItem -> false
            type != other.type -> false
            isLabel() && text == other.text -> true
            isRecordingOrEpisodes() && recording?.reference == other.recording?.reference -> true
            else -> false
        }
    }

    private fun isLabel() = type == ColumnItemType.LABEL

    private fun isRecordingOrEpisodes() = type == ColumnItemType.RECORDING || type == ColumnItemType.RECORDING_EPISODES
}