package com.twentyfouri.tvlauncher.data

import com.twentyfouri.androidcore.epg.model.EpgEvent
import com.twentyfouri.androidcore.epg.model.EpgEventLabel
import com.twentyfouri.smartmodel.model.dashboard.SmartMediaItem

class EpgEventExt(
    val smartMediaItem: SmartMediaItem,
    labelDrawables: ArrayList<EpgEventLabel>,
    noDataId: String? = null
) : EpgEvent(
    noDataId ?: "id-${smartMediaItem.reference.hashCode()}",
    smartMediaItem.startDate?.millis ?: 0,
    smartMediaItem.endDate?.millis ?: 0,
    smartMediaItem.title,
    labelDrawables
) {
    fun removeRecordingLabel() {
        labels.removeAll { it.id == LABEL_ID_RECORDINGS }
    }

    fun addLabel(recordingEpgEventLabel: EpgEventLabel?) {
        if (recordingEpgEventLabel != null) {
            labels.removeAll { it.id == recordingEpgEventLabel.id }
            labels.add(recordingEpgEventLabel)
        }
    }

    companion object {
        const val LABEL_ID_RECORDINGS = "recordings"
    }
}