package com.twentyfouri.tvlauncher.data

import android.content.Context
import com.twentyfouri.tvlauncher.R

class RecordingSettingsRepository(context: Context) {
    private val prefs = context.applicationContext.getSharedPreferences(RECORDING_SETTINGS_PREFS_FILE, Context.MODE_PRIVATE)

    fun setStartBefore(id: String) {
        RecordingOffset.fromString(id).also {
            prefs.edit()
                .putInt(RECORDING_START_BEFORE_KEY, it.minutes)
                .putInt(RECORDING_START_BEFORE_STRING_RES_KEY, it.stringRes())
                .apply()
        }
    }

    fun setStartAfter(id: String) {
        RecordingOffset.fromString(id).also {
            prefs.edit()
                .putInt(RECORDING_START_AFTER_KEY, it.minutes)
                .putInt(RECORDING_START_AFTER_STRING_RES_KEY, it.stringRes())
                .apply()
        }
    }

    fun getStartBefore(): Int = prefs
        .getInt(RECORDING_START_BEFORE_KEY, 5)

    fun getStartBeforeStringRes(): Int = prefs
        .getInt(RECORDING_START_BEFORE_STRING_RES_KEY, R.string.personal_settings_recording_time_5)

    fun getStartAfter(): Int = prefs
        .getInt(RECORDING_START_AFTER_KEY, 5)

    fun getStartAfterStringRes(): Int = prefs
        .getInt(RECORDING_START_AFTER_STRING_RES_KEY, R.string.personal_settings_recording_time_5)

    companion object {
        private const val RECORDING_SETTINGS_PREFS_FILE = "recording_settings"
        private const val RECORDING_START_BEFORE_KEY = "start_before"
        private const val RECORDING_START_BEFORE_STRING_RES_KEY = "start_before_string_res"
        private const val RECORDING_START_AFTER_KEY = "start_after"
        private const val RECORDING_START_AFTER_STRING_RES_KEY = "start_after_string_res"
    }
}

enum class RecordingOffset(val minutes: Int) {
    ONE(1) { override fun stringRes() = R.string.personal_settings_recording_time_1 },
    TWO(2) { override fun stringRes() = R.string.personal_settings_recording_time_2 },
    FIVE(5) { override fun stringRes() = R.string.personal_settings_recording_time_3 },
    TEN(10) { override fun stringRes() = R.string.personal_settings_recording_time_4 },
    FIFTEEN(15) { override fun stringRes() = R.string.personal_settings_recording_time_5 };

    abstract fun stringRes(): Int

    companion object {
        fun fromString(minutesString: String) = when(minutesString) {
            ONE.minutes.toString() -> ONE
            TWO.minutes.toString() -> TWO
            FIVE.minutes.toString() -> FIVE
            TEN.minutes.toString() -> TEN
            FIFTEEN.minutes.toString() -> FIFTEEN
            else -> FIFTEEN
        }
    }
}