package com.twentyfouri.tvlauncher.extensions

import com.twentyfouri.smartmodel.model.dashboard.SmartMediaItem
import com.twentyfouri.smartmodel.model.dashboard.SmartMediaType
import com.twentyfouri.smartmodel.model.media.SmartMediaDetail
import com.twentyfouri.smartmodel.model.media.SmartSeekingRuleType
import com.twentyfouri.tvlauncher.Flavor
import com.twentyfouri.tvlauncher.common.provider.TimeProvider
import com.twentyfouri.tvlauncher.data.DateTimeRepository
import com.twentyfouri.tvlauncher.viewmodels.MetadataViewModel

fun SmartMediaItem.seekingRuleAllowsStartover(isCatchup: Boolean?): Boolean = when(seekingRuleType) {
    SmartSeekingRuleType.STARTOVER,
    SmartSeekingRuleType.TIMESHIFT -> true
    SmartSeekingRuleType.LIVE_STARTOVER,
    SmartSeekingRuleType.LIVE_TIMESHIFT -> isCatchup != true
    SmartSeekingRuleType.CATCHUP_STARTOVER,
    SmartSeekingRuleType.CATCHUP_TIMESHIFT -> isCatchup != false
    SmartSeekingRuleType.LIVE_ONLY,
    null -> false
}

fun SmartMediaItem.seekingRuleAllowsCatchup(): Boolean = seekingRuleAllowsStartover(isCatchup = true)

fun SmartMediaDetail.isOnAirNow()
        = startDate != null
        && startDate!!.millis < TimeProvider.nowMs()
        && endDate != null
        && endDate!!.millis > TimeProvider.nowMs()

fun SmartMediaDetail.isCatchup()
        = endDate?.millis != null
        && endDate!!.millis / DateTimeRepository.MILLIS_IN_MINUTE < TimeProvider.now().millis / DateTimeRepository.MILLIS_IN_MINUTE //end time accuracy to minutes, needed for catchup flag
        && seekingRuleAllowsCatchup()
        && Flavor().isCatchupStreamAvailable(this)
        && broadcastEnd?.isAfter(TimeProvider.now().minusDays(Flavor().getEpgConfigValues.EPG_DAYS_INTO_PAST)) == true

fun SmartMediaDetail.isBrokenLive()
        = type == SmartMediaType.LIVE_EVENT
        && startDate == null
        && endDate == null