package com.twentyfouri.tvlauncher.receiver

import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.util.Log
import android.view.KeyEvent
import com.twentyfouri.smartmodel.model.menu.SmartNavigationAction
import com.twentyfouri.smartmodel.model.menu.SmartNavigationTarget
import com.twentyfouri.tvlauncher.ui.MainActivity
import com.twentyfouri.tvlauncher.ui.actions.ActivityPlayerAction
import com.twentyfouri.tvlauncher.utils.Navigator
import timber.log.Timber

class GlobalButtonReceiver(private val activityPlayerAction: ActivityPlayerAction): BroadcastReceiver() {

    override fun onReceive(context: Context?, intent: Intent?) {

        if (intent != null) {
            when (intent.action) {
                MainActivity.ACTION_APP_LINK_KEY -> {
                    Timber.d("Received key event via app link: $intent" )
                    val keyCode = intent.getIntExtra("keyCode", KeyEvent.KEYCODE_UNKNOWN)
                    activityPlayerAction.handleGlobalKeyButton(KeyEvent(KeyEvent.ACTION_UP,
                        keyCode))
                }
                MainActivity.INTENT_GLOBAL_BUTTON -> {
                    Timber.d("Received key event via global button intent: $intent" )
                    val bundle = intent.extras
                    val keyEvent: KeyEvent? = bundle?.get(Intent.EXTRA_KEY_EVENT) as? KeyEvent
                    if (keyEvent != null) {
                        activityPlayerAction.handleGlobalKeyButton(keyEvent)
                    }
                }
                else -> {} // do nothing
            }
        }
    }
    private companion object{
        private const val TAG = "GlobalButtonReceiver"
    }
}