package com.twentyfouri.tvlauncher.ui

import androidx.appcompat.app.AppCompatDelegate
import androidx.appcompat.app.BaseContextWrappingDelegate
import androidx.fragment.app.strictmode.FragmentStrictMode
import androidx.fragment.app.strictmode.Violation
import com.google.firebase.crashlytics.FirebaseCrashlytics
import com.twentyfouri.tvlauncher.common.utils.logging.OselToggleableLogger
import org.koin.androidx.scope.ScopeActivity
import timber.log.Timber

open class BaseActivity : ScopeActivity() {

    init {
        supportFragmentManager.strictModePolicy = FragmentStrictMode.Policy.Builder()
            .detectFragmentReuse()
            .detectFragmentTagUsage()
            .detectRetainInstanceUsage()
            .detectSetUserVisibleHint()
            .detectTargetFragmentUsage()
            .detectWrongFragmentContainer()
            .penaltyLog()
            .penaltyListener { violation ->
                FirebaseCrashlytics.getInstance().recordException(violation)
            }
            .build()
    }

    private var baseContextWrappingDelegate: AppCompatDelegate? = null

    override fun getDelegate() = baseContextWrappingDelegate ?: BaseContextWrappingDelegate(
        super.getDelegate()
    ).apply {
        baseContextWrappingDelegate = this
    }

    override fun onPause() {
        Timber.tag(OselToggleableLogger.TAG_UI_LOG).d("Activity paused: ${this::class.java.simpleName}")
        super.onPause()
    }

    override fun onResume() {
        Timber.tag(OselToggleableLogger.TAG_UI_LOG).d("Activity resumed: ${this::class.java.simpleName}")
        super.onResume()
    }
}