package com.twentyfouri.tvlauncher.ui

import android.app.Application
import android.content.Context
import com.twentyfouri.tvlauncher.common.ui.ForceLocaleHelper
import com.twentyfouri.tvlauncher.BuildConfig
import com.twentyfouri.tvlauncher.common.utils.logging.OselToggleableLoggerPermissions
import com.twentyfouri.tvlauncher.di.allModules
import com.twentyfouri.tvlauncher.receiver.TimeChangeReceiver
import com.twentyfouri.tvlauncher.utils.DebugTree
import com.twentyfouri.tvlauncher.utils.ReleaseTree
import com.twentyfouri.tvlauncher.utils.StringsMapper
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.GlobalScope
import kotlinx.coroutines.launch
import org.koin.android.ext.koin.androidContext
import org.koin.android.ext.koin.androidLogger
import org.koin.core.context.GlobalContext.startKoin
import timber.log.Timber

//import st.suite.android.suitestinstrumentalservice.SuitestInstrumentalApplication

@Suppress("unused")
class LauncherApplication : Application() {

    override fun onCreate() {
        super.onCreate()
        Timber.tag("Restart").i("LauncherApplication.onCreate")

        Timber.plant(
            if (BuildConfig.DEBUG) {
                DebugTree()
            } else {
                ReleaseTree()
            }
        )

//        if (BuildConfig.IS_DEBUG) {
//            SuitestInstrumentalApplication.init(this)
//        }
        StringsMapper.initialize(this)

        GlobalScope.launch(Dispatchers.IO) {
            TimeChangeReceiver.autoTimeSettings = android.provider.Settings.Global.getInt(
                contentResolver,
                android.provider.Settings.Global.AUTO_TIME,
                0
            )
        }

        startKoin {
            androidLogger()
            androidContext(this@LauncherApplication)
            modules(allModules)
        }
    }

    override fun attachBaseContext(base: Context) =
        super.attachBaseContext(ForceLocaleHelper.onAttachBaseContextApplication(base))
}