package com.twentyfouri.tvlauncher.ui.actions

import android.view.KeyEvent
import com.twentyfouri.smartmodel.model.dashboard.SmartMediaReference
import com.twentyfouri.tvlauncher.ui.PlayerLocation
import com.twentyfouri.tvlauncher.utils.RemoteControlState


interface ActivityPlayerAction {
    fun playerStop(onlyInForeground: Boolean = false)
    fun togglePlayerFrontBack()
    fun playerPlay(location: PlayerLocation, mediaReference: SmartMediaReference, isSoftZap: Boolean = false)
    fun showNumberZap(number: String)
    fun playNumberZapChanel(number: String, controlState: RemoteControlState)
    fun requestFocusAfterReturningFromSubscriptions()
    fun requestLastFocusedView()
    fun provideLastPlayerLocation(): PlayerLocation
    fun restartPlayerOnChannel()
    fun handleGlobalKeyButton(keyEvent: KeyEvent)
    fun checkRemoteStateAfterReturnFromSubscriptions()
}