package com.twentyfouri.tvlauncher.utils

import android.content.Context
import android.widget.Toast
import com.twentyfouri.tvlauncher.Flavor
import com.twentyfouri.tvlauncher.common.extensions.ifTrue
import com.twentyfouri.tvlauncher.common.ui.TvLauncherToast
import com.twentyfouri.tvlauncher.common.utils.ActiveConnectionInfoWifi
import com.twentyfouri.tvlauncher.common.utils.NetworkInfo
import com.twentyfouri.tvlauncher.common.utils.WiFiSignalQualityRange

object ConnectionMessagesHelper {

    fun checkConnectionAndShowMessage(context: Context?) {
        if (Flavor().shouldDisplayMessageOnConnectionError) {
            val currentNetworkRssi = (NetworkInfo.getActiveConnectionInfo(context) as? ActiveConnectionInfoWifi)?.rssi
            (currentNetworkRssi in WiFiSignalQualityRange.RED.rssiRange).ifTrue {
                showConnectionToast(
                    context = context,
                    text = context?.getString(com.twentyfouri.tvlauncher.common.R.string.connection_message_toast) ?: ""
                )
            }
        }
    }

    private fun showConnectionToast(context: Context?, text: String) {
        if (context != null)
            TvLauncherToast.makeText(
                    context,
                    text,
                    Toast.LENGTH_LONG
            )?.show()
    }
}