package com.twentyfouri.tvlauncher.utils

import android.content.ActivityNotFoundException
import android.content.Context
import android.content.Intent
import android.util.Log
import androidx.core.content.IntentCompat
import timber.log.Timber
import java.net.URISyntaxException

object IntentLauncher {
    private const val TVRECOMMENDATIONS_PACKAGE_NAME = "com.google.android.tvrecommendations"
    private const val TAG = "IntentLauncher"

//    fun launchMediaIntentFromUri(context: Context, uri: String) {
//        launchIntentFromUri(context, uri, true)
//    }

//    fun launchIntentFromUri(context: Context, uri: String) {
//        launchIntentFromUri(context, uri, false)
//    }
//
//    private fun launchIntentFromUri(context: Context, uri: String, launchMedia: Boolean) {
//        if (!launchIntent(context, parseUri(uri, launchMedia))) {
//            YoufoneToast.makeText(context, "Failed to launch", Toast.LENGTH_SHORT)?.show()
//        }
//    }

    fun buildMediaIntentFromUriByPackage(packageName: String, uri: String): Intent?
            = launchIntentFromUriByPackage(packageName, uri, true)

    private fun launchIntentFromUriByPackage(
        packageName: String,
        uri: String,
        launchMedia: Boolean
    ): Intent? {
        val intent = parseUri(uri, launchMedia)
        intent?.setPackage(packageName)
        return intent
    }

    private fun parseUri(uri: String?, launchMedia: Boolean): Intent? {
        if (uri == null) {
            Timber.e("No URI provided")
            return null
        }
        try {
            val intent = Intent.parseUri(uri, Intent.URI_INTENT_SCHEME)
            if (!launchMedia) {
                return intent
            }
            intent.putExtra(IntentCompat.EXTRA_START_PLAYBACK, true)
            return intent
        } catch (e: URISyntaxException) {
            Timber.e("Bad URI syntax: $uri")
            return null
        }

    }

    fun launchIntent(context: Context, intent: Intent?): Boolean {
        if (intent == null) {
            return false
        }
        val pm = context.packageManager
        val activities = pm.queryIntentActivities(intent, 0)
        if (activities == null || activities.size <= 0) {
            intent.setPackage(TVRECOMMENDATIONS_PACKAGE_NAME)
            val receivers = pm.queryBroadcastReceivers(intent, 0)
            if (receivers == null || receivers.size <= 0) {
                Timber.e("Activity not found for intent: $intent")
                return false
            }
            context.sendBroadcast(intent)
            return true
        }
        return try {
            context.startActivity(intent)
            true
        } catch (e: ActivityNotFoundException) {
            Timber.e(e, "Failed to launch $intent")
            false
        }
    }
}
