package com.twentyfouri.tvlauncher.utils

import kotlinx.coroutines.sync.Mutex

object MutexProvider {
    private val channelNumberToMutexMap = HashMap<Int, Mutex>()

    public fun getOrCreateMutexForChannelNumber(channelNumber: Int) =
        channelNumberToMutexMap.getOrPut(channelNumber) { Mutex() }

    public fun clear() = channelNumberToMutexMap.clear()
}