package com.twentyfouri.tvlauncher.viewmodels

import android.content.Context
import androidx.lifecycle.*
import com.twentyfouri.androidcore.utils.ImageSpecification
import com.twentyfouri.tvlauncher.common.data.ResourceRepository
import com.twentyfouri.tvlauncher.data.*
import com.twentyfouri.tvlauncher.widgets.SettingsItemType

class FavoriteAppsPickerViewModel(
    val appListRepository: AppListRepository
) : ViewModel() {

    private val getAllFavoriteApps = appListRepository.getFavoriteAppsSelectionList()

    fun getAppListItems(): List<ListPickerItem>{
        return getAllFavoriteApps.map { appItem ->
            ListPickerItem(
                id = appItem.intent.component?.packageName ?: appItem.intent.`package` ?: appItem.label.toString(),
                label = "",
                title = appItem.label.toString(),
                icon = getImageSpecification(appItem),
                subtitle = "",
                type = SettingsItemType.TITLE_WITH_ICON,
                appListItem = appItem
            )
        }
    }

    fun onItemClicked(item: ListPickerItem){
        val favoriteApps = appListRepository.getFavoriteAppsFromDatabase()
        appListRepository.storeFavoriteApp(
            appItem = item.appListItem!!,
            favoritePriority = favoriteApps.size + 1
        )
    }

    private fun getImageSpecification(it: AppListItem) = object : ImageSpecification() {
        override fun getImmediateDrawable(context: Context) = it.banner

        //NOT USED right now. If you need to use this function, current implementation works as get(), not copy()
        override fun copy(): ImageSpecification = this
    }




    companion object {}
}