package com.twentyfouri.tvlauncher.viewmodels

import androidx.lifecycle.*
import com.twentyfouri.tvlauncher.data.*

class FavoriteAppsViewModel(
    val appListRepository: AppListRepository
) : ViewModel() {

    private val favoriteApps: List<AppUsage> = appListRepository.getFavoriteAppsFromDatabase()

    private var selectedAppId: String? = null

    fun setSelectedAppId(appId: String?) {
        selectedAppId = appId
    }

    fun removeSelectedItem() {
        val appsToUpdate = favoriteApps.filterIndexed { index, _ ->
            index >= favoriteApps.indexOfFirst { selectedAppId == it.packageName }
        }
        val appsToUpdateFixed = appsToUpdate.mapIndexed { index, appUsage ->
            if (index == 0) {
                appUsage.apply { favoritePriority = 0 }
            } else {
                appUsage.apply { favoritePriority -= 1 }
            }
        }
        appListRepository.insertFavoriteApp(appsToUpdateFixed)
    }
}