package com.twentyfouri.tvlauncher.viewmodels

import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.Transformations
import androidx.lifecycle.ViewModel
import com.twentyfouri.tvlauncher.common.data.ResourceRepository
import com.twentyfouri.tvlauncher.data.DateTimeRepository
import com.twentyfouri.tvlauncher.data.channel.ExternalRowItem

class MetadataAppChannelProgramViewModel(
    private val dateTimeRepository: DateTimeRepository,
    private val resourceRepository: ResourceRepository
) : ViewModel() {

    private val programLD = MutableLiveData<ExternalRowItem>()

    val title: LiveData<String>
    val description: LiveData<String>

    init {
        title = Transformations.map(programLD) { it.title }
        description = Transformations.map(programLD) { it.shortDescription }
    }

    fun setProgram(externalRowItem: ExternalRowItem) {
        programLD.value = externalRowItem
    }
}