package com.twentyfouri.tvlauncher.widgets

import android.content.Context
import android.util.AttributeSet
import com.twentyfouri.tvlauncher.widgets.leanback.VerticalGridView

class HomeListView : VerticalGridView {
    private val mOnAnimationsFinishedListener = ItemAnimator.ItemAnimatorFinishedListener {
        if (!this@HomeListView.isComputingLayout && this@HomeListView.isLayoutSuppressed) {
            this@HomeListView.suppressLayout(false)
            this@HomeListView.requestLayout()
        }
    }

    constructor(context: Context) : super(context) {
        init()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        init()
    }

    constructor(context: Context, attrs: AttributeSet, defStyle: Int) : super(
        context,
        attrs,
        defStyle
    ) {
        init()
    }

    private fun init() {
        setHasFixedSize(false)
    }

    /* access modifiers changed from: protected */
    override fun onLayout(changed: Boolean, l: Int, t: Int, r: Int, b: Int) {
        super.onLayout(changed, l, t, r, b)
        val animator = itemAnimator
        if (animator != null && animator.isRunning) {
            animator.isRunning(this.mOnAnimationsFinishedListener)
            suppressLayout(true)
        } else if (isLayoutSuppressed) {
            suppressLayout(false)
        }
    }
}