package com.twentyfouri.tvlauncher.widgets

import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.View.OnFocusChangeListener
import android.widget.Button
import android.widget.FrameLayout
import androidx.lifecycle.LifecycleOwner
import com.twentyfouri.tvlauncher.common.extensions.enlarge
import com.twentyfouri.tvlauncher.common.utils.logging.OselToggleableLogger
import com.twentyfouri.tvlauncher.databinding.OfflineRowBinding
import com.twentyfouri.tvlauncher.viewmodels.OfflineRowViewModel
import com.twentyfouri.tvlauncher.viewmodels.RowViewModel
import org.koin.core.component.KoinComponent
import org.koin.core.component.get
import timber.log.Timber

class OfflineRow @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0
): FrameLayout(context, attrs, defStyleAttr), KoinComponent {
    val binding: OfflineRowBinding
    private var focusedChildIsMine = false

    init {

        binding = OfflineRowBinding.inflate(
            LayoutInflater.from(context),
            this, true
        ).apply {
            lifecycleOwner = context as LifecycleOwner
            viewModel = get<OfflineRowViewModel>()
        }
        val onButtonFocused = OnFocusChangeListener { view, hasFocus ->
            if (view is Button) {
                view.enlarge(hasFocus)
            }
            val buttonFocused = binding.buttonOnline.hasFocus() || binding.buttonSettings.hasFocus()
            binding.rowViewModel?.isFocused?.value = buttonFocused
            focusedChildIsMine = if (buttonFocused) {
                if (!focusedChildIsMine) {
                    //offline row should be always first so simplify log and skip trying to determine which index it really is
                    Timber.tag(OselToggleableLogger.TAG_UI_LOG).d("Row 0-0 focused: Offline row")
                }
                if(hasFocus) {
                    if (binding.buttonOnline.hasFocus()) Timber.tag(OselToggleableLogger.TAG_UI_LOG).d("Row item 0 focused: ${binding.buttonOnline.text} ")
                    if (binding.buttonSettings.hasFocus()) Timber.tag(OselToggleableLogger.TAG_UI_LOG).d("Row item 1 focused: ${binding.buttonSettings.text} ")
                }
                true
            } else {
                false
            }
        }
        binding.buttonOnline.onFocusChangeListener = onButtonFocused
        binding.buttonSettings.onFocusChangeListener = onButtonFocused
    }

    fun bind(rowViewModel: RowViewModel) {
        binding.rowViewModel = rowViewModel
    }
}