package com.twentyfouri.tvlauncher.widgets

import android.content.Context
import android.view.LayoutInflater
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.databinding.DataBindingUtil
import androidx.lifecycle.LifecycleOwner
import androidx.lifecycle.Observer
import com.twentyfouri.smartexoplayer.ui.StandardControlsHelper
import com.twentyfouri.tvlauncher.R
import com.twentyfouri.tvlauncher.databinding.PlayerControlsVodBinding
import com.twentyfouri.tvlauncher.di.viewModel
import com.twentyfouri.tvlauncher.viewmodels.PlayerUIVodViewModel

class PlayerUIVod(context: Context) : PlayerUIBase(context) {

    override val viewModel: PlayerUIVodViewModel by viewModel()
    override val binding = DataBindingUtil.inflate<PlayerControlsVodBinding>(
            LayoutInflater.from(context),
            R.layout.player_controls_vod,
            this,
            true
    )

    init {
        val lifecycleOwner = context as LifecycleOwner
        binding.lifecycleOwner = lifecycleOwner
        binding.viewModel = viewModel
        viewModel.ageRatings.observe(lifecycleOwner, Observer { binding.mediaRestrictionIcons.viewModel.setContentIcons(it) })
    }

    override val standardHelpers: List<StandardControlsHelper> = listOf(
            timerHelper, hidingHelper
    )

    override fun getToastBottomOffset(): Int {
        return super.getToastBottomOffset() + ((binding.bottomGuideline.layoutParams as? ConstraintLayout.LayoutParams)?.guideEnd ?: 0)
    }

}