package com.twentyfouri.tvlauncher.widgets

import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.View
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.databinding.DataBindingUtil
import androidx.lifecycle.LifecycleOwner
import com.twentyfouri.tvlauncher.R
import com.twentyfouri.tvlauncher.data.ColumnItem
import com.twentyfouri.tvlauncher.databinding.RecordingItemBinding
import com.twentyfouri.tvlauncher.viewmodels.RecordingItemViewModel
import org.koin.core.component.KoinComponent
import org.koin.core.component.inject

class RecordingItemView @JvmOverloads constructor(
    context: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0
) : ConstraintLayout (context, attrs, defStyleAttr), KoinComponent {

    lateinit var binding : RecordingItemBinding

    init {
        val viewModelFromFactory: RecordingItemViewModel by inject()

        binding = DataBindingUtil.inflate<RecordingItemBinding>(
            LayoutInflater.from(context),
            R.layout.recording_item,
            this,
            true
        ).apply {
            viewModel = viewModelFromFactory
            lifecycleOwner = context as LifecycleOwner
        }

        setOnClickListener {
            viewModelFromFactory.onClick()
        }

        addOnAttachStateChangeListener(object : OnAttachStateChangeListener{
            override fun onViewAttachedToWindow(v: View) {}
            override fun onViewDetachedFromWindow(v: View) {
                viewModelFromFactory.resetClickedItem()
            }
        })
    }

    fun bind(item: ColumnItem) { binding.viewModel?.setColumnItem(item) }
}