package com.twentyfouri.tvlauncher.widgets

import android.annotation.SuppressLint
import android.content.Context
import android.graphics.Bitmap
import android.graphics.Canvas
import android.graphics.Color
import android.graphics.PorterDuff
import android.graphics.drawable.Drawable
import android.util.AttributeSet
import android.widget.ImageView
import androidx.core.graphics.drawable.RoundedBitmapDrawable
import androidx.core.graphics.drawable.RoundedBitmapDrawableFactory
import com.twentyfouri.tvlauncher.R

class RoundedImageView : ImageView {
    constructor(context: Context) : this(context, null)

    constructor(context: Context, attributeSet: AttributeSet?) : super(context, attributeSet) {
        init(attributeSet)
    }

    var corner = 0

    private fun init(attrs: AttributeSet?) {
        val a = context.obtainStyledAttributes(attrs, R.styleable.RoundedImageView)
        for (index in 0 until a.indexCount) {
            val attr = a.getIndex(index)
            when (attr) {
                R.styleable.RoundedImageView_corner -> corner = a.getDimensionPixelSize(attr, 0)
            }
        }
        a.recycle()
    }

    private var canvasTmp = Canvas()
    private var bitmap = Bitmap.createBitmap(1, 1, Bitmap.Config.ARGB_8888)
    private var roundedDrawable: RoundedBitmapDrawable? = null

    override fun onSizeChanged(w: Int, h: Int, oldw: Int, oldh: Int) {
        super.onSizeChanged(w, h, oldw, oldh)
        bitmap = Bitmap.createBitmap(Math.max(width, 1), Math.max(height, 1), Bitmap.Config.ARGB_8888)
        canvasTmp = Canvas(bitmap)
    }

    @SuppressLint("WrongCall")
    private fun prepareRoundedDrawable() {
        canvasTmp.drawColor(Color.TRANSPARENT, PorterDuff.Mode.CLEAR)
        super.onDraw(canvasTmp)
        roundedDrawable = RoundedBitmapDrawableFactory.create(resources, bitmap).apply {
            cornerRadius = corner.toFloat()
        }
        roundedDrawable?.setBounds(0, 0, Math.max(width, 1), Math.max(height, 1))
    }

    override fun setImageDrawable(drawable: Drawable?) {
        super.setImageDrawable(drawable)
//        prepareRoundedDrawable()
    }

    override fun invalidate() {
//        prepareRoundedDrawable()
        super.invalidate()
    }

    override fun onDraw(canvas: Canvas?) {
        // we have to call every time, because for some reason apps banner refused to setup otherwise
        prepareRoundedDrawable()
        roundedDrawable?.draw(canvas!!)
    }
}