package com.twentyfouri.tvlauncher.widgets

import android.content.Context
import android.util.AttributeSet
import android.view.View
import com.twentyfouri.tvlauncher.widgets.leanback.HorizontalGridView

class RowGridView : HorizontalGridView {
    private val mOnAnimationsFinishedListener = ItemAnimator.ItemAnimatorFinishedListener {
        if (!this@RowGridView.isComputingLayout && this@RowGridView.isLayoutSuppressed) {
            this@RowGridView.suppressLayout(false)
            this@RowGridView.requestLayout()
        }
    }

    constructor(context: Context) : super(context) {
        init()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        init()
    }

    constructor(context: Context, attrs: AttributeSet, defStyle: Int) : super(
        context,
        attrs,
        defStyle
    ) {
        init()
    }

    private fun init() {
        setHasFixedSize(false)
    }

    override fun focusSearch(focused: View, direction: Int): View {
        return if (focused.isSelected) {
            swapItemsIfNeeded(focused, direction)
        } else super.focusSearch(focused, direction)
    }

    private fun swapItemsIfNeeded(focused: View, direction: Int): View {
        val position = getChildAdapterPosition(focused)
        if (itemAnimator?.isRunning?.not() == true) {
            if (canMoveInDirection(position, direction)) {
                when (direction) {
                    FOCUS_LEFT -> {
                        (findAncestorRowView(focused) as? RowView)?.moveRowItem(position, position-1)
                    }
                    FOCUS_UP -> {} // Do nothing
                    FOCUS_RIGHT -> {
                        (findAncestorRowView(focused) as? RowView)?.moveRowItem(position, position+1)
                    }
                    FOCUS_DOWN -> {} // Do nothing
                }
            }
        }

    return focused
    }

    private fun findAncestorRowView(v: View): View? {
        var target = v.parent
        while (target != null) {
            if (target is RowView) {
                return target
            }
            target = target.parent
        }
        return null
    }

    private fun canMoveInDirection(position: Int, direction: Int): Boolean {
        return when (direction) {
            FOCUS_LEFT -> {
                position  > 0
            }
            FOCUS_RIGHT -> {
                position < adapter!!.itemCount - 1
            }
            else -> {
                false
            }
        }
    }

    /* access modifiers changed from: protected */
    override fun onLayout(changed: Boolean, l: Int, t: Int, r: Int, b: Int) {
        super.onLayout(changed, l, t, r, b)
        val animator = itemAnimator
        if (animator != null && animator.isRunning) {
            animator.isRunning(this.mOnAnimationsFinishedListener)
            suppressLayout(true)
        } else if (isLayoutSuppressed) {
            suppressLayout(false)
        }
    }
}