package com.twentyfouri.tvlauncher.common.analytics

import android.content.Context
import com.npaw.youbora.lib6.plugin.Options
import com.npaw.youbora.lib6.plugin.Plugin
import com.twentyfouri.tvlauncher.common.Flavor

class YouboraPlugin(options: Options, appContext: Context) : Plugin(options, appContext) {

    var allowReportStopPlayback: Boolean = false

    /**
     * Disable request sending when contentTitle is null or empty
     */
    fun disableIfTitleNullOrEmpty(){
        if (options.contentTitle.isNullOrEmpty()) disable()
    }

    /**
     * Enable request sending if Youbora should be enabled.
     */
    fun reenableIfNecessary() {
        if (!options.isEnabled && Flavor().isYouboraEnabled) enable()
    }
}