package com.twentyfouri.tvlauncher.common.provider

import org.joda.time.DateTime
import kotlin.math.absoluteValue

object TimeProvider {

    private var timeOffsetMilliseconds = 0L

    fun refreshUsingServerTime(serverTimeMilliseconds: Long) {
        timeOffsetMilliseconds = serverTimeMilliseconds - DateTime.now().millis
    }

    /**
     * If server time is one hour in future -> offset should be passed as 3600000ms.
     * If server time is one hour in past -> offset should be passed as -3600000ms.
     */
    fun refreshUsingOffset(offset: Long) {
        timeOffsetMilliseconds = offset
    }

    /**
     * True if absolute value of timeOffsetMilliseconds is greater than 5 minutes. False otherwise
     */
    fun isOutOfSync() : Boolean = (timeOffsetMilliseconds.absoluteValue > 5*60*1000)

    fun now() : DateTime {
        if (timeOffsetMilliseconds > 0) return DateTime.now().plus(timeOffsetMilliseconds)
        return DateTime.now().minus((-1)*timeOffsetMilliseconds)
    }

    fun nowMs() : Long = now().millis
}