package com.twentyfouri.tvlauncher.common.receiver

import android.annotation.SuppressLint
import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.util.Log
import com.twentyfouri.tvlauncher.common.extensions.ifTrue
import com.twentyfouri.tvlauncher.common.utils.SerialNumberReceiverHelper
import timber.log.Timber

class SerialNumberReceiver(private val serialNumberReceiverHelper: SerialNumberReceiverHelper, private val storeResult: Boolean = true) : BroadcastReceiver() {

    companion object {
        val INTENT_FILTER_ACTION = "com.sdmc.serialnumber"
        val INTENT_EXTRA_ID = "SerialNumber"
        val SP_FILE = "SerialNumber"
        val SP_ID = "S/N"
    }

    @SuppressLint("ApplySharedPref")
    override fun onReceive(context: Context?, intent: Intent?) {
        try {
            val receivedId = intent?.getStringExtra(INTENT_EXTRA_ID)
            if (storeResult) {
                val shared = context?.getSharedPreferences(SP_FILE, Context.MODE_PRIVATE)
                Timber.tag("getDeviceIdFromBroadcast").d(receivedId.toString())
                shared?.edit()?.putString(SP_ID, receivedId)?.commit()
                serialNumberReceiverHelper.onSerialNumberReceived(context)
            } else {
                serialNumberReceiverHelper.onSerialNumberReceivedWithResult(receivedId, context)
            }
        } catch (exception: Exception) {
            storeResult.ifTrue { serialNumberReceiverHelper.onSerialNumberReceiverError() }
            Timber.tag("getDeviceIdFromBroadcast")
                .e("Serial number couldn't be obtained from broadcast")
        }
    }
}