package com.twentyfouri.tvlauncher.common.ui

import android.content.Intent
import android.view.View
import com.twentyfouri.tvlauncher.common.utils.NetworkQualityCheckTimer
import java.lang.Exception

interface MainActivityAction {
    fun startStopRecording()
    fun startStopRecordingInPlayer()
    fun backFromSubscriptionDialog()
    fun handleEpgButtonPress(i: Intent, remoteControlState: String)
    fun handleLiveButtonPress()
    fun restartActivity()
    fun planRestartActivity()
    fun checkAndMaybeRestartActivity()
    fun isForegroundPlaybackActive(): Boolean
    fun isLauncher(): Boolean
    fun findCurrentFocus(): View?
    fun stopPlayerInStandby()
    fun reportApiException(exception: Exception)
    fun resolveDialogBackOptionPress()
    fun isInOnlineMode(): Boolean
    fun provideNQC(): NetworkQualityCheckTimer?
}