package com.twentyfouri.tvlauncher.common.ui

import android.content.Context
import android.content.ContextWrapper
import android.graphics.Color
import android.graphics.LightingColorFilter
import android.util.AttributeSet
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.widget.LinearLayout
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.databinding.DataBindingUtil
import androidx.lifecycle.LifecycleOwner
import com.twentyfouri.tvlauncher.common.R
import com.twentyfouri.tvlauncher.common.databinding.SemaphoreBinding


class Semaphore @JvmOverloads constructor(
        context: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0
) : ConstraintLayout(context, attrs, defStyleAttr) {

    private var nullableBinding: SemaphoreBinding? = DataBindingUtil.inflate<SemaphoreBinding>(
            LayoutInflater.from(context),
            R.layout.semaphore,
            this,
            true
    )

    val binding: SemaphoreBinding
        get() = nullableBinding ?: throw IllegalStateException("trying to access uninitialized binding")

    init {
        setLights(SemaphoreState.OFF)
    }

    fun setLights(state: SemaphoreState) {
        val drawable = when (state) {
            SemaphoreState.RED_WIFI -> context.getDrawable(R.drawable.semaphore_red_wifi)
            SemaphoreState.RED_LAN -> context.getDrawable(R.drawable.semaphore_red_lan)
            SemaphoreState.ORANGE_WIFI -> context.getDrawable(R.drawable.semaphore_yellow_wifi)
            SemaphoreState.ORANGE_LAN -> context.getDrawable(R.drawable.semaphore_yellow_lan)
            SemaphoreState.GREEN_WIFI -> context.getDrawable(R.drawable.semaphore_green_wifi)
            SemaphoreState.GREEN_LAN -> context.getDrawable(R.drawable.semaphore_green_lan)
            SemaphoreState.OFF -> null
        }
        binding.light.setImageDrawable(drawable)
    }
}

enum class SemaphoreState {
    RED_WIFI,
    RED_LAN,
    ORANGE_WIFI,
    ORANGE_LAN,
    GREEN_WIFI,
    GREEN_LAN,
    OFF
}
