package com.twentyfouri.tvlauncher.common.ui

import android.content.Context
import android.view.LayoutInflater
import android.widget.TextView
import android.widget.Toast
import com.twentyfouri.tvlauncher.common.R
import com.twentyfouri.tvlauncher.common.utils.logging.OselToggleableLogger
import timber.log.Timber

/**
 * Styled replacement for Android toasts
 */
object TvLauncherToast {
    private var lastToast: Toast? = null
    private var lastText: String = ""

    fun makeText(context: Context, text: String, duration: Int):Toast? {
        val inflater = context.getSystemService(Context.LAYOUT_INFLATER_SERVICE) as LayoutInflater
        val toastView = inflater.inflate(R.layout.toast, null)
        val textView = toastView.findViewById(R.id.custom_toast_text) as TextView
        textView.text = text

        if(lastText == text && lastToast != null && lastToast?.view?.isShown == true) {
            Timber.tag(OselToggleableLogger.TAG_UI_LOG).d("Toast already displayed: $text")
            return null
        } else {
            Timber.tag(OselToggleableLogger.TAG_UI_LOG).d("Toast displayed: $text")
            val toast = Toast(context.applicationContext).apply {
                this.duration = duration
                this.view = toastView
            }

            lastToast = toast
            lastText = text
            return toast
        }
    }

    fun makeText(context: Context, resId: Int, duration: Int):Toast? {
        return makeText(context, context.getString(resId), duration)
    }
}