package com.twentyfouri.tvlauncher.common.ui.messagedialog

import android.view.KeyEvent
import androidx.annotation.IntDef

interface MessageDialogFragmentListener {

    /**
     * Returning value is used just for [MessageDialogAction.Event] -> when true key event is consumed
     */
    fun onResult(answer: MessageDialogAction): Boolean

    companion object {
        fun from(listener: (MessageDialogAction) -> Boolean) = object: MessageDialogFragmentListener {
            override fun onResult(answer: MessageDialogAction) = listener(answer)
        }
    }
}

sealed class MessageDialogAction {
    data class Result(@MessageDialgResultType val type: Int): MessageDialogAction()
    data class Event(val keyEvent: KeyEvent): MessageDialogAction()
    data class CheckBox(val checked: Boolean): MessageDialogAction()
}

const val CANCEL = 0
const val OPTION_A = 1
const val OPTION_B = 2
const val OPTION_C = 3

@Retention(AnnotationRetention.SOURCE)
@IntDef(CANCEL, OPTION_A, OPTION_B, OPTION_C)
annotation class MessageDialgResultType