package com.twentyfouri.tvlauncher.common.ui.pindialog

import android.os.Parcel
import android.os.Parcelable

data class PinDialogModel (
    var message: String? = null,
    var messageDescription: String? = null
) : Parcelable {

    constructor(parcel: Parcel) : this(
        parcel.readString(),
        parcel.readString()
    )

    override fun writeToParcel(parcel: Parcel, flags: Int) {
        parcel.writeString(message)
        parcel.writeString(messageDescription)
    }

    override fun describeContents(): Int {
        return 0
    }

    companion object CREATOR : Parcelable.Creator<PinDialogModel> {
        override fun createFromParcel(parcel: Parcel): PinDialogModel {
            return PinDialogModel(parcel)
        }

        override fun newArray(size: Int): Array<PinDialogModel?> {
            return arrayOfNulls(size)
        }
    }

}