package com.twentyfouri.tvlauncher.common.ui.pindialog

import android.content.Context
import android.os.Bundle
import android.view.ViewGroup.LayoutParams.WRAP_CONTENT
import androidx.lifecycle.ViewModelProvider
import com.twentyfouri.tvlauncher.common.R
import com.twentyfouri.tvlauncher.common.databinding.PurchaseDialogPinBinding
import com.twentyfouri.tvlauncher.common.ui.BaseDialogFragment

class PurchasePinDialogFragment: BaseDialogFragment<PurchaseDialogPinBinding>(), PinDialogView {

    override val layoutRes = R.layout.purchase_dialog_pin
    var mListener: PinDialogFragmentListener? = null
    private lateinit var viewModel: PinDialogViewModel

    override fun onBindViewModel(binding: PurchaseDialogPinBinding) {
        viewModel = ViewModelProvider(this)[PinDialogViewModel::class.java]
        viewModel.view = this
        viewModel.model = arguments?.getParcelable(PARAM_MODEL)
        binding.viewModel = viewModel
    }

    companion object {
        private const val PARAM_MODEL = "model"

        fun newInstance(model: PinDialogModel) = PurchasePinDialogFragment().apply {
            arguments = Bundle().apply {
                putParcelable(PARAM_MODEL, model)
            }
        }
    }

    // region Binded

    override fun onResult(answer: Boolean?, keyCode: Int?) {
        mListener?.onResult(answer, keyCode)
        this.dismiss()
    }

    // endregion

    override fun onStart() {
        super.onStart()

        val width = resources.getDimensionPixelSize(R.dimen.pin_dialog_width)
        dialog?.window?.setLayout(width, WRAP_CONTENT)

    }

    override fun onAttach(context: Context) {
        super.onAttach(context)
        //WARNING this can override the listener if it was set from outside previously
        if (context is PinDialogFragmentListener)
            mListener = context
    }
}
