package com.twentyfouri.tvlauncher.common.utils

import android.os.Build

data class AndroidOsVersion(val codename: String, val version: String, val api:Int) {
    override fun toString(): String {
        return "API: $api, Codename: $codename, Version: $version"
    }
}

val androidOsVersions: List<AndroidOsVersion> = listOf(
        AndroidOsVersion("Android11","11",30),
        AndroidOsVersion("Android10","10",29),
        AndroidOsVersion("Pie","9",28),
        AndroidOsVersion("Oreo","8.1.0",27),
        AndroidOsVersion("Oreo","8.0.0",26),
        AndroidOsVersion("Nougat","7.1",25),
        AndroidOsVersion("Nougat","7.0",24),
        AndroidOsVersion("Marshmallow","6.0",23),
        AndroidOsVersion("Lollipop","5.1",22),
        AndroidOsVersion("Lollipop","5.0",21),
        AndroidOsVersion("KitKat","4.4W",20),
        AndroidOsVersion("KitKat","4.4 - 4.4.4",19),
        AndroidOsVersion("Jelly Bean","4.3.x",18),
        AndroidOsVersion("Jelly Bean","4.2.x",17),
        AndroidOsVersion("Jelly Bean","4.1.x",16),
        AndroidOsVersion("Ice Cream Sandwich","4.0.3 - 4.0.4",15),
        AndroidOsVersion("Ice Cream Sandwich","4.0.1 - 4.0.2",14),
        AndroidOsVersion("Honeycomb","3.2.x",13),
        AndroidOsVersion("Honeycomb","3.1",12),
        AndroidOsVersion("Honeycomb","3.0",11),
        AndroidOsVersion("Gingerbread","2.3.3 - 2.3.7",10),
        AndroidOsVersion("Gingerbread","2.3 - 2.3.2",9),
        AndroidOsVersion("Froyo","2.2.x",8),
        AndroidOsVersion("Eclair","2.1",7),
        AndroidOsVersion("Eclair","2.0.1",6),
        AndroidOsVersion("Eclair","2.0",5),
        AndroidOsVersion("Donut","1.6",4),
        AndroidOsVersion("Cupcake","1.5",3),
        AndroidOsVersion("(no codename)","1.1",2),
        AndroidOsVersion("(no codename)","1.0",1)
)

val deviceOsVersion = androidOsVersions.find { it.api == Build.VERSION.SDK_INT } ?: AndroidOsVersion("UNKNOWN", "UNKNOWN", Build.VERSION.SDK_INT)
