package com.twentyfouri.tvlauncher.common.utils

import androidx.fragment.app.Fragment
import androidx.lifecycle.Lifecycle
import androidx.lifecycle.LifecycleObserver
import androidx.lifecycle.OnLifecycleEvent
import kotlin.properties.ReadWriteProperty
import kotlin.reflect.KProperty

/** this class is meant to be used as a property Delegate for properties which should be cleared
 * with the lifecycle */
class LifecycleAwareProperty<T : Any> : ReadWriteProperty<Fragment, T>, LifecycleObserver {
    private var _value: T? = null

    override fun getValue(f: Fragment, property: KProperty<*>): T =
            _value ?: throw IllegalStateException("Trying to call an lifecycle-aware value outside of the view lifecycle.")

    override fun setValue(f: Fragment, property: KProperty<*>, value: T) {
        f.viewLifecycleOwner.lifecycle.removeObserver(this)
        _value = value
        f.viewLifecycleOwner.lifecycle.addObserver(this)
    }

    @OnLifecycleEvent(Lifecycle.Event.ON_DESTROY)
    fun onDestroy() {
        _value = null
    }
}