package com.twentyfouri.tvlauncher.common.utils

import android.content.Intent
import androidx.fragment.app.DialogFragment
import com.twentyfouri.smartmodel.model.menu.SmartNavigationTarget

/**
 * Class can not be instantiated. It has to be extended in project module.
 *
 * WARNING: project module extension has to call insertInstance in its companion object
 *
 * companion object {
 *  init {
 *      NavigatorCommon.insertInstance(getInstance())
 *  }
 *  @Volatile private var instance: Navigator? = null
 *  fun getInstance() =
 *  instance ?: synchronized(this) {
 *  instance ?: Navigator().also { instance = it }
 *  }
 * }
 *
 */
abstract class NavigatorCommon {

    interface NavigatorContractCommon {
        fun navigateDialog(fragment: DialogFragment)
        fun navigate(intent: Intent)
        fun navigateLoader(visible: Boolean, handleSplash: Boolean, delay: Long = 0)
        fun navigate(target: SmartNavigationTarget)
    }

    protected var pendingNavigationTarget: SmartNavigationTarget? = null
    protected var pendingNavigationDialogFragment: DialogFragment? = null

    //do NOT make this public
    protected var navigatorContractCommon: NavigatorContractCommon? = null

    fun hasContract() = navigatorContractCommon != null

    abstract fun navigate(target: SmartNavigationTarget?)

    fun navigate(intent: Intent) {
        navigatorContractCommon?.also { it.navigate(intent) }
    }

    fun navigateLoader(visible: Boolean, handleSplash: Boolean, delay: Long = 0) {
        navigatorContractCommon?.also { it.navigateLoader(visible, handleSplash, delay) }
    }

    fun navigateDialog(fragment: DialogFragment) {
        if (navigatorContractCommon == null) pendingNavigationDialogFragment = fragment
        else navigatorContractCommon?.also { it.navigateDialog(fragment) }
    }

    companion object {

        private var instance: NavigatorCommon? = null

        /**
         * This has to be filled by class that will extend us in main module
         */
        @Suppress("unused")
        fun insertInstance(instance: NavigatorCommon) {
            this.instance = instance
        }

        fun getInstance() =
            instance ?: throw IllegalStateException("NavigatorCommon not provided")
    }
}