package com.twentyfouri.tvlauncher.common.utils

import android.content.Context
import androidx.fragment.app.FragmentActivity
import com.twentyfouri.tvlauncher.common.R
import com.twentyfouri.tvlauncher.common.ui.pindialog.PinDialogFragment
import com.twentyfouri.tvlauncher.common.ui.pindialog.PinDialogFragmentListener
import com.twentyfouri.tvlauncher.common.ui.pindialog.PinDialogModel
import com.twentyfouri.tvlauncher.common.ui.pindialog.PurchasePinDialogFragment

/**
 * Created by Jakub Juroska on 11/10/20.
 */
object PurchaseChecker {

    var purchasePinDialogFragment: PurchasePinDialogFragment? = null
    var parentalPinDialogFragment: PinDialogFragment? = null

    fun checkPurchaseWithPin(context: Context, doAfterPinVerified: () -> Unit = {}) {
        val messageDialogModel = PinDialogModel(
                context.getString(R.string.dialog_parental_pin_message, context.resources.getInteger(R.integer.pin_length)),
                context.getString(R.string.not_subscribed_pin_description))
        parentalPinDialogFragment = PinDialogFragment.newInstance(messageDialogModel)
        parentalPinDialogFragment?.mListener = object: PinDialogFragmentListener {
            override fun onResult(answer: Boolean?, keyCode: Int?) {
                if (answer == true) {
                    doAfterPinVerified.invoke()
                }
            }
        }
        parentalPinDialogFragment?.let {
            NavigatorCommon.getInstance().navigateDialog(it)
        }
    }

    fun checkPurchaseWithPurchasePin(context: Context, doAfterPinVerified: () -> Unit = {}) {
        val messageDialogModel = PinDialogModel(
                context.getString(R.string.dialog_parental_pin_message, context.resources.getInteger(R.integer.pin_length)),
                context.getString(R.string.not_subscribed_pin_description))
        purchasePinDialogFragment = PurchasePinDialogFragment.newInstance(messageDialogModel)
        purchasePinDialogFragment?.mListener = object: PinDialogFragmentListener {
            override fun onResult(answer: Boolean?, keyCode: Int?) {
                if (answer == true) {
                    doAfterPinVerified.invoke()
                }
            }
        }
        purchasePinDialogFragment?.let {
            NavigatorCommon.getInstance().navigateDialog(it)
        }
    }

    fun dismissPurchasePinDialog(){
        purchasePinDialogFragment?.dismiss()
        purchasePinDialogFragment = null
    }

    fun dismissPinDialog() {
        parentalPinDialogFragment?.dismiss()
        parentalPinDialogFragment = null
    }
}