package com.twentyfouri.searchproxy.resourcegen

import kotlinx.serialization.Serializable
import java.util.*

/**
 * This generator's arguments are passed in a JSON object.
 * It does make command-line testing more tricky, but allows
 * the build script to pass more complex data.
 */
@Serializable
data class Arguments(
    val src: String,
    val dest: String,
    val flavors: List<List<FlavorInfo>>,
    val baseApplicationId: String
)

@Serializable
data class FlavorInfo(
    val name: String,
    val packageSuffix: String
)

typealias VariantConsumer = (strings: StringResources, variant: Variant, lang: String) -> Unit
typealias Variant = List<FlavorInfo>
typealias Dimension = List<FlavorInfo>

fun Variant.getVariantName() = this
    .mapIndexed { idx, flavor ->
        if (idx != 0) flavor.name.capitalizeUS()
        else flavor.name
    }.joinToString(separator = "")

fun Variant.getVariantApplicationIdSuffix() = this
    .joinToString(prefix = ".", separator = ".") { it.packageSuffix }

// capitalize() is unsafe, but capitalize(locale) is experimental API
fun String.capitalizeUS(): String {
    if (length < 2) {
        return toUpperCase(Locale.US)
    }
    return substring(0, 1).toUpperCase(Locale.US) + substring(1)
}