package com.twentyfouri.searchproxy.resourcegen

import org.w3c.dom.*
import java.io.File
import javax.xml.parsers.DocumentBuilderFactory
import javax.xml.transform.OutputKeys
import javax.xml.transform.TransformerFactory
import javax.xml.transform.dom.DOMSource
import javax.xml.transform.stream.StreamResult

/**
 * Utility methods for dealing with verbose Java XML document libraries
 */

fun File.readXmlDocument():Document =
    DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this)

fun createNewXmlDocument():Document =
    DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()

fun Element.getAttributeOrNull(key: String):String? =
    if (hasAttribute(key)) getAttribute(key)
    else null

fun NodeList.toElementsList():List<Element> = ArrayList<Element>().also {
    for (i in 0 until length) {
        val child = item(i)
        if (child is Element) it.add(child)
    }
}

fun Document.writeToFile(file:File) {
    file.parentFile.mkdirs()
    val transformer = TransformerFactory.newInstance().newTransformer()
    transformer.setOutputProperty(OutputKeys.INDENT, "yes")
    transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4")
    transformer.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, "yes")
    file.outputStream().use {
        transformer.transform(
            DOMSource(this),
            StreamResult(it)
        )
    }
}