package com.twentyfouri.searchproxy.providers

import android.annotation.SuppressLint
import android.content.ContentProvider
import android.content.ContentValues
import android.database.Cursor
import android.net.Uri
import com.twentyfouri.searchproxy.R

class SearchProxyProvider : ContentProvider() {

    override fun getType(uri: Uri): String? = null

    override fun insert(uri: Uri, values: ContentValues?): Uri? = null

    override fun delete(uri: Uri, selection: String?, selectionArgs: Array<String>?): Int = 0

    override fun update(uri: Uri, values: ContentValues?, selection: String?, selectionArgs: Array<String>?): Int = 0

    override fun query(
        uri: Uri,
        projection: Array<String>?,
        selection: String?,
        selectionArgs: Array<String>?,
        sortOrder: String?
    ): Cursor? {
        val query = context?.run {
            getString(R.string.target_search_query,
                getString(R.string.target_search_package),
                getString(R.string.target_search_path))
        } ?: ""

        return context?.contentResolver?.query(
            Uri.parse(query),
            null,
            selection,
            selectionArgs,
            null
        )
    }

    @SuppressLint("NewApi")
    override fun onCreate(): Boolean {
        return true
    }
}

