package com.twentyfouri.tvlauncher.setupwizard

import com.twentyfouri.smartmodel.backstage.reference.BackstageUserProfileReference
import com.twentyfouri.smartmodel.model.user.SmartLoginCredentials
import com.twentyfouri.smartmodel.model.user.SmartLoginCredentialsConnectCode
import com.twentyfouri.smartmodel.model.user.SmartLoginCredentialsPassword
import com.twentyfouri.smartmodel.serialization.SmartDataObject
import com.twentyfouri.tvlauncher.common.data.ResourceRepository
import com.twentyfouri.tvlauncher.setupwizard.basesetup.BaseSetupModel
import com.twentyfouri.tvlauncher.setupwizard.postcoresetup.Screens
import com.twentyfouri.tvlauncher.setupwizard.postcoresetup.models.*

class Flavor : FlavorBase() {

    override val usernameScreenList = listOf(
        Screens.InitialScreen,
        Screens.UsernameScreen,
        Screens.PasswordScreen
    )

    override val pinScreenList = listOf(
        Screens.InitialScreen,
        Screens.PinScreen
    )

    override fun getLoginCredentialsType(loginCredentials: LoginCredentials): SmartLoginCredentials {
        return if (loginCredentials.username != null && loginCredentials.password != null) {
            SmartLoginCredentialsPassword(loginCredentials.username.orEmpty(), loginCredentials.password.orEmpty())
        } else {
            SmartLoginCredentialsConnectCode(loginCredentials.pin.toString())
        }
    }

    override fun getUserProfileReference(userName: String) = BackstageUserProfileReference(userName, null)

    override fun gdprProfileChangeObject(isGdrpAccepted: Boolean?) = SmartDataObject(Pair("", false))

    override fun isGdprAcceptedProfile(extras: SmartDataObject, modelRecommendations: Boolean) = modelRecommendations.not()

    fun processErrorMessage(code: String, resourceRepository: ResourceRepository): String = getErrorMessage(code,resourceRepository)

    private fun getErrorMessage(code: String, resourceRepository: ResourceRepository)
            = resourceRepository.getString(R.string.unexpected_error_auth, code)

}